#include <sun/stab.h>
#include <sun/stabsunos5.h>
#include <sun/elf.h>
#include <ctype.h>
#include "symtab.h"
#include "dtype.h"
#include "symbol.h"
#include "sunossymtab.h"
#include "sunos5symtab.h"
#include "core.h"
SRCFILE("sunos5symtab.c")

static char symsect[]		 = ".stab";
static char symstringsect[]	 = ".stabstr";
static char symtabsect[]	 = ".symtab";
static char symtabstringsect[]	 = ".strtab";

int ccdemangle(char**,char* =0,int =0);
void SymbolStats();

Sunos5SymTab::Sunos5SymTab(Core* c, int fd, SymTab *i, long r)
 :SunosSymTab(c, fd, i, r) {}

Sunos5SymTab::~Sunos5SymTab()
{
	delete elfhdr;
	delete [] shdr;
	delete [] base;
	delete [] sstrings;
}

char *Sunos5SymTab::gethdr()
{
	elfhdr = new Elf32_Ehdr;
	if (lseek(fd, 0L, 0) == -1 || !ReadOK(fd, (char*)elfhdr,sizeof *elfhdr))
		return SysErr("ELF header: ");
	if (elfhdr->e_ident[EI_MAG0] != ELFMAG0 ||
	    strncmp((char*)&elfhdr->e_ident[EI_MAG1], "ELF", 3) ||
	    elfhdr->e_ident[EI_CLASS] != ELFCLASS32 ||
	    elfhdr->e_ident[EI_DATA] != ELFDATA2MSB ||
	    elfhdr->e_type != ET_EXEC ||
	    elfhdr->e_machine != EM_SPARC)
		return "symbol table: not SPARC ELF executable";
	nsect = elfhdr->e_shnum;
	shdr = new Elf32_Shdr[nsect];
	if (lseek(fd, elfhdr->e_shoff, 0) == -1 ||
	    !ReadOK(fd, (char*)shdr, sizeof(*shdr) * nsect))
		return SysErr("ELF section headers: ");
	int nbytes = (int)shdr[elfhdr->e_shstrndx].sh_size;
	sstrings = new char[nbytes];
	if (lseek(fd, shdr[elfhdr->e_shstrndx].sh_offset, 0) == -1 ||
	    !ReadOK(fd, sstrings, nbytes))
		return SysErr("ELF section strings: ");
	Elf32_Shdr *s, *ss, *se = &shdr[nsect];
	for (s = shdr; s < se; s++)
		s->sh_name += (long)sstrings;

	int sect = findelfsect(symstringsect);
	if (!sect)
		return "No symbol table strings";
	ss = &shdr[sect];
	strsize = ss->sh_size;
	sect = findelfsect(symsect);
	if (!sect)
		return "No symbolic info";
	s = &shdr[sect];
	entries = s->sh_size/sizeof(nlist);

	base = new nlist[entries];
	strings = new char[strsize];
	if (lseek(fd, s->sh_offset, 0) == -1 ||
	    !ReadOK(fd, (char*)base, (int)(entries * sizeof(nlist))) ||
	    lseek(fd, ss->sh_offset, 0) == -1 ||
	    !ReadOK(fd, strings, (int)strsize))
		return SysErr("symbol table entries: ");
	nlist *n, *n2, *ne = &base[entries];
	long noff, offset = (long)strings;
	for(n = base; n < ne; ) {
		if (n->n_type)
			return "symbol table: bad strings";
		noff = n->n_value;
		for(n2 = n + n->n_desc+1; n < n2; n++)
			n->n_un.n_name += offset;
		offset += noff;
	}
	return 0;
}

int Sunos5SymTab::findelfsect(char *string)
{
	Elf32_Shdr *s, *se = shdr + nsect;
	for (s = shdr + 1; s < se; s++)
		if (!strcmp(s->sh_name, string))
			return s - shdr;
	return 0;
}

Block *Sunos5SymTab::gatherfunc(Func *func)
{
	register struct nlist *n;
	register Block *ablk, *lblk;
	Var *arg = 0, *lcl = 0;
	register Stmt *stmt = 0;
	long bfun = func->begin, size = func->size;
	char *so = func->source()->_text;
	SunosSource *src = (SunosSource *)func->typeinfo;
	SunosType *suntype = src->typeinfo;
	char *subtype;
	long startaddr, value;
	DType *t;

	++FunctionGathered;
	SymbolStats();
	IF_LIVE( bfun < 0 || bfun+size > entries ) return 0;
	if (size == 0)
		return fakeblk();
	n = base + bfun;
	struct nlist *ne = n + size;
	IF_LIVE( n->n_type != N_FUN ) return 0;
	ablk = new Block( this, 0, 0, sf("%s().arg_blk",n->n_un.n_name) );
	lblk = new Block( this, ablk, 0, sf("%s().lcl_blk",n->n_un.n_name) );
	ablk->child = lblk;
	ablk->range.hi = ablk->range.lo = startaddr = func->range.lo;
	long ininclude = 0;
	for( ; n < ne; n++ ){
		switch( n->n_type ){
		case N_PSYM:
			gathervar( n, &arg, ablk, U_ARG, suntype );
			// Symbol table lies about structures passed as args
			if (arg->type.isstrun()) {
				t = new DType(arg->type);
				arg->type = t->incref();
			}
			break;
		case N_LSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype ||
			    (subtype[1] != '(' && !isdigit(subtype[1])))
				break;
			gathervar( n, &lcl, lblk, U_AUT, suntype, subtype );
			break;
		case N_STSYM:
		case N_LCSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype || subtype[1] != 'V')
				break;
			if (src->suncc) {
				if (n->n_type == N_STSYM)
					n->n_value += src->datastart;
				else
					n->n_value += src->bssstart;
			}
			n->n_value += relocation;
			gathervar( n, &lcl, lblk, U_STA, suntype, subtype );
			break;
		case N_RSYM:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype)
				break;
			//  Register arg cc(p) and gcc(P)
			if (subtype[1] == 'p' || subtype[1] == 'P') {
				gathervar(n, &arg, ablk,U_REG,suntype,subtype);
				if (arg->type.isstrun()) {
					t = new DType(arg->type);
					arg->type = t->incref();
				}
				// Ignore 2nd reg entry with Sun cc
				if ((n+1)->n_type == N_RSYM &&
				    (n+1)->n_value == n->n_value)
					n++;
			} else
				gathervar(n, &lcl, lblk,U_REG,suntype,subtype);
			break;
		case N_SOL:
			if (!strcmp(n->n_un.n_name, so))
				ininclude = 0;
			else
				ininclude = 1;
			break;
		case N_SLINE:
			if (ininclude)
				break;
			value = n->n_value + startaddr;
			if (stmt)
				stmt->range.hi = value;
			stmt = new Stmt(this,lblk,stmt);
			if( !ablk->stmt ) ablk->stmt = stmt;
			stmt->lineno = n->n_desc;
			stmt->range.lo = value;
			break;
		}
	}
	if (func->range.hi) {
		if (stmt) stmt->range.hi = func->range.hi;
		ablk->range.hi = func->range.hi;
	} else if (stmt) {
		stmt->range.hi = stmt->range.lo + 20;
		ablk->range.hi = stmt->range.lo;
	}
	uncfront( ablk->var, (char *)0 );
	uncfront( lblk->var, (char *)0 );
	return ablk;

}

void Sunos5SymTab::dosymtab(Var *glb, SunosSource *src)
{
	char *name, *srcname;
	Var *resolve;
	Func *f;
	DType *t;
	Elf32_Sym *s, *se;
	Block *fake = fakeblk();
	int bind;

	int sect = findelfsect(symtabsect);
	int ssect = findelfsect(symtabstringsect);
	if (!sect || !ssect)
		return;
	int nchar = (int)shdr[ssect].sh_size;
	int nsyms = (int)shdr[sect].sh_size/sizeof(Elf32_Sym);
	char *symstrings = new char[nchar];
	Elf32_Sym *syms = new Elf32_Sym[nsyms];
	if (lseek(fd, shdr[sect].sh_offset, 0) == -1 ||
	    !ReadOK(fd, (char*)syms, (int)(nsyms * sizeof(Elf32_Sym))) ||
	    lseek(fd, shdr[ssect].sh_offset, 0) == -1 ||
	    !ReadOK(fd, symstrings, nchar))
		goto out;
	for (se = syms + nsyms, s = syms; s < se; s++) {
		if (!s->st_name)
			continue;
		name = symstrings + s->st_name;
		switch(ELF32_ST_TYPE(s->st_info)) {
		case STT_FUNC:
			ccdemangle(&name);
			if ((f = (Func*)idtosym(U_FUNC, name, 0))) {
				if (!f->range.lo)
					f->range.lo = s->st_value + relocation;
				if (!f->range.hi)
					f->range.hi = f->range.lo + s->st_size;
				break;
			}
			name = sf("%s", name);
			f = new Func(this, name, 0, 0);
			f->range.lo = s->st_value + relocation;
			f->range.hi = f->range.lo + s->st_size;
			f->_blk = fake;
			t = new DType;
			t->pcc = LONG;
			f->type = t->incref();
			f->type.pcc = FTN;
			break;
		case STT_OBJECT:
			bind = ELF32_ST_BIND(s->st_info);
			if (bind != STB_GLOBAL && bind != STB_WEAK)
				break;
			ccdemangle(&name);
			resolve = (Var*)idtosym(U_GLB, name, 0);
			s->st_value += relocation;
			if (resolve) {
				if(!resolve->range.lo)
					resolve->range.lo = s->st_value;
			} else {
				name = sf("%s", name);
				glb = new Var(this, _blk, glb, U_GLB, name);
				if(!_blk->var )
					_blk->var = glb;
				glb->range.lo = s->st_value;
				glb->type.pcc = LONG;
			}
			break;
		}
	}
	for(s = syms; s < se; s++) {
		while (src && !src->suncc)
			src = (SunosSource*)src->rsib;
		if (!src)
			break;
		srcname = src->text();
		for ( ; s < se; s++) {
			if (!s->st_name)
				continue;
			if (ELF32_ST_TYPE(s->st_info) == STT_FILE &&
		   	    !strcmp(srcname, symstrings + s->st_name))
				break;
		}
		if (s == se)
			break;
		for (s++; s < se; s++) {
			if (ELF32_ST_TYPE(s->st_info)!=STT_NOTYPE||!s->st_name)
				continue;
			name = symstrings + s->st_name;
			if (!strcmp(name, "Ddata.data"))
				src->datastart = s->st_value;
			else if (!strcmp(name, "Bbss.bss")) {
				src->bssstart = s->st_value;
				break;
			}
		}
		src = (SunosSource*)src->rsib;
	}
out:
	delete [] syms;
	delete [] symstrings;
}

Source *Sunos5SymTab::tree()
{
	register nlist	*n, *lastn, *n2;
	SunosSource	*src = 0, *lsrc = 0, *hsrc = 0;
	Func		*func = 0;
	Var		*glb = 0, *fst = 0;
	register long	inafunc = 0;
	long		lastline = 1;
	char		*equal, *subtype;
	char		*name, *directory = 0;
	char		*lastsol;
	SunosType	*suntype = 0;
	DType		*t;
	int		ininclude = 0;
	int		demangled;
	int		braketdepth = 0;
	
	lastn = base + entries;
	glb = globregs(_blk, _core->nregs());
	sunosshare = new SunosTShare;
	for (n = base; n < lastn; n++) {
		if (equal = strchr(n->n_un.n_name, '='))
			suntype->parsetype(equal, n->n_un.n_name);
		switch (n->n_type) {
		case N_GSYM:
			if (!(subtype = strchr(n->n_un.n_name, ':')))
				break;
			*subtype = 0;
			ccdemangle(&n->n_un.n_name);
			if (!idtosym(U_GLB, n->n_un.n_name, 0)) {
				n->n_value += relocation;
				gathervar(n,&glb,_blk,U_GLB,suntype,subtype);
			}
			break;
		case N_LCSYM:
			if (!(subtype = strchr(n->n_un.n_name, ':')))
				break;
			if (subtype[1] != 'S')
				break;
			n->n_value += relocation;
			gathervar(n,&fst,src->blk,U_FST,suntype,subtype);
			break;
		case N_SLINE:
			if (!ininclude)
				lastline = n->n_desc;
			break;
		case N_BINCL:	// Include files for type indexing
			suntype->addinclude(n->n_un.n_name, 1, n->n_value);
			break;
		case N_EXCL:
			suntype->addinclude(n->n_un.n_name, 0, n->n_value);
			break;
		case N_SOL:
			name = n->n_un.n_name;
			if (!strcmp(name, src->_text))
				lastsol = 0;
			else
				lastsol = name;
			if (!inafunc || !strcmp(name, hsrc->_text))
				ininclude = 0;
			else
				ininclude = 1;
			break;
		case N_SO:
			if (n->n_un.n_name[strlen(n->n_un.n_name)-1] == '/') {
				directory = n->n_un.n_name;
				break;
			}
			lastline = 1;
			lsrc = new SunosSource(this,lsrc,n->n_un.n_name,0);
			hsrc = src = lsrc;
			src->dir = directory;
			suntype = src->typeinfo= new SunosType(src, sunosshare);
			func = 0;
			inafunc = 0;
			ininclude = 0;
			lastsol = 0;
			fst = 0;
			break;
		case N_VERS:
			if (n->n_value)
				src->suncc = 1; // Compiled with Sun cc
			break;
		case N_BMOD:
			if (inafunc) {
				inafunc = 0;
				func->lines.hi = lastline;
				func->size = n - base - func->begin - 1;
			}
			break;
		case N_RBRAC:
			if (--braketdepth <= 0) {
				inafunc = 0;
				func->lines.hi = lastline;
				func->size = n - base - func->begin;
			}
			break;
		case N_LBRAC:
			braketdepth++;
			break;
		case N_FUN:
			subtype = strchr(n->n_un.n_name, ':');
			if (!subtype || (subtype[1] != 'F' && subtype[1] !='f'))
				break;
			for (n2 = n + 1; n2 < lastn; n2++) {
			  if (n2->n_type == N_SLINE || n2->n_type == N_BMOD)
				break;
			  if (n2->n_type == N_SOL) {
				name = n2->n_un.n_name;
				lastsol = strcmp(name, src->_text) ? name : 0;
			  }
			}
			if (n2 >= lastn || n2->n_type == N_BMOD)
				break;
			if (lastsol) {
				for (hsrc = lsrc; hsrc;
				     hsrc = (SunosSource*)hsrc->lsib)
					if (!strcmp(lastsol, hsrc->_text))
						break;
				if (!hsrc) {
					hsrc = lsrc = new
					  SunosSource(this,lsrc,lastsol,0);
					hsrc->dir = directory;
				}
			} else
				hsrc = src;
			if (inafunc) {
				func->lines.hi = lastline;
				func->size = n - base - func->begin - 1;
			}
			if (func)
				func->range.hi = n->n_value + relocation;
			inafunc = 1;
			braketdepth = 0;
			ininclude = 0;
			++FunctionStubs;
			subtype = strchr(n->n_un.n_name, ':');
			*subtype++ = 0;
			name = n->n_un.n_name;
			demangled = ccdemangle(&name);
			func = new Func(this, name, hsrc, n2->n_desc);
			if (demangled) {
				name = n->n_un.n_name;
				ccdemangle(&name, 0, 1);
				func->namewithargs = name;
			}
			func->typeinfo = src;
			func->begin = n - base;
			func->range.lo = n->n_value + relocation;
			t = new DType(suntype->gettype(subtype));
			func->type = t->incref();
			func->type.pcc = FTN;
			break;
		}
	}
	if (inafunc) {
		func->lines.hi = lastline;
		func->size = n - base - func->begin - 1;
	}
	while(lsrc && lsrc->lsib)
		lsrc = (SunosSource*)lsrc->lsib;

	dosymtab(glb, lsrc);
	return lsrc;
}
